<?php
// Configure session cookie settings
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_samesite', 'Lax');
ini_set('session.use_strict_mode', 1);

// Start session safely
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

// Site Configuration
define('SITE_URL', 'https://esim.matinacard.com');
define('SITE_NAME', 'اولesim');

// eSIM Access API Configuration
define('ESIM_API_URL', 'https://api.esimaccess.com/api/v1');
define('ESIM_ACCESS_CODE', '33335253e83a461ab9b7cdd2403983a1');
define('ESIM_SECURITY_KEY', '1adc4efb0c944b8185a68d0efa75c042');

// Iran Server Configuration (for proxy payments)
define('IRAN_SERVER_URL', 'https://payesim.matinacard.ir/proxy-handler.php');

// Include database
require_once __DIR__ . '/database.php';

// Helper function to get setting
function getSetting($key, $default = '') {
    $conn = getDBConnection();
    $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->bind_param("s", $key);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        $value = $row['setting_value'];
    } else {
        $value = $default;
    }
    
    $stmt->close();
    $conn->close();
    return $value;
}

// Helper function to update setting
function updateSetting($key, $value) {
    $conn = getDBConnection();
    $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
    $stmt->bind_param("sss", $key, $value, $value);
    $result = $stmt->execute();
    $stmt->close();
    $conn->close();
    return $result;
}

// Check if user is logged in (via session or token)
function isLoggedIn() {
    // Check session first
    if (isset($_SESSION['user_id']) && !empty($_SESSION['user_id'])) {
        return true;
    }
    
    // Check for token in Authorization header or query parameter
    $token = null;
    
    // Check Authorization header
    $headers = getallheaders();
    if (isset($headers['Authorization'])) {
        $token = str_replace('Bearer ', '', $headers['Authorization']);
    }
    
    // Check query parameter (for GET requests)
    if (!$token && isset($_GET['token'])) {
        $token = $_GET['token'];
    }
    
    // Check POST parameter
    if (!$token && isset($_POST['token'])) {
        $token = $_POST['token'];
    }
    
    if ($token) {
        $user = getUserByToken($token);
        if ($user) {
            // Set session variables
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['mobile'] = $user['mobile'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['is_admin'] = $user['is_admin'];
            return true;
        }
    }
    
    return false;
}

// Get user by token
function getUserByToken($token) {
    $conn = getDBConnection();
    $stmt = $conn->prepare("
        SELECT u.* 
        FROM users u 
        INNER JOIN auth_tokens t ON u.id = t.user_id 
        WHERE t.token = ? AND t.expires_at > NOW()
    ");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();
    $conn->close();
    return $user;
}

// Check if user is admin
function isAdmin() {
    return isset($_SESSION['is_admin']) && $_SESSION['is_admin'] == 1;
}

// Require login
function requireLogin() {
    // Set global flag that this page requires authentication
    global $requireAuth;
    $requireAuth = true;
    
    if (!isLoggedIn()) {
        header('Location: /login.php');
        exit;
    }
}

// Require admin
function requireAdmin() {
    if (!isAdmin()) {
        header('Location: /');
        exit;
    }
}

// Format price in Toman
function formatPrice($price) {
    return number_format($price, 0, '.', ',');
}

// Convert USD to IRR (Toman)
function usdToIrr($usd) {
    $rate = getSetting('usd_to_irr', 650000);
    return round($usd * $rate);
}

// Convert Persian/Arabic numbers to English
function convertPersianToEnglish($string) {
    $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
    $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    
    $string = str_replace($persian, $english, $string);
    $string = str_replace($arabic, $english, $string);
    
    return $string;
}

// Sanitize input
function sanitize($input) {
    return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
}

// Validate mobile number
function validateMobile($mobile) {
    $mobile = convertPersianToEnglish($mobile);
    return preg_match('/^09[0-9]{9}$/', $mobile);
}

// Validate email
function validateEmail($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

