# 🌐 سیستم فروش eSIM

پلتفرم کامل فروش و مدیریت eSIM های بین‌المللی با پرداخت زرین‌پال

---

## 📋 مشخصات

- **زبان برنامه‌نویسی:** PHP 7.4+
- **پایگاه داده:** MySQL 5.7+
- **API خارجی:** eSIM Access API
- **درگاه پرداخت:** ZarinPal (با پروکسی ایران)

---

## ✨ امکانات

### برای کاربران:
- ✅ مشاهده لیست بسته‌های eSIM
- ✅ جستجو بر اساس کشور
- ✅ ثبت نام و ورود
- ✅ خرید و پرداخت آنلاین
- ✅ دریافت QR Code و کد فعال‌سازی
- ✅ مشاهده تاریخچه سفارشات

### برای مدیران:
- ✅ مشاهده کل سفارشات
- ✅ مدیریت تنظیمات
- ✅ تنظیم نرخ ارز
- ✅ مدیریت زرین‌پال

---

## 📁 ساختار پروژه

```
esimnew/
├── config/
│   ├── config.php          # تنظیمات اصلی
│   └── database.php        # تنظیمات دیتابیس
├── includes/
│   ├── header.php          # هدر سایت
│   ├── footer.php          # فوتر سایت
│   └── functions.php       # توابع کمکی
├── api/
│   └── esim-api.php        # API eSIM Access
├── admin/
│   └── index.php           # پنل مدیریت
├── index.php               # صفحه اصلی
├── login.php               # ورود/ثبت‌نام
├── checkout.php            # صفحه خرید
├── dashboard.php           # داشبورد کاربر
├── order-view.php          # جزئیات سفارش
├── proxy-payment.php       # پرداخت (سرور آلمان)
├── proxy-callback.php      # بازگشت پرداخت (سرور آلمان)
├── proxy-handler.php       # هندلر پرداخت (سرور ایران)
├── logout.php              # خروج
└── install.php             # نصب اولیه
```

---

## 🚀 نصب و راه‌اندازی

### 1️⃣ آپلود فایل‌ها

#### سرور آلمان (esim.matinacard.com):
تمام فایل‌ها به جز `proxy-handler.php` را آپلود کنید

#### سرور ایران (payesim.matinacard.ir):
فقط فایل `proxy-handler.php` را آپلود کنید

### 2️⃣ تنظیم دیتابیس

فایل `config/database.php` را ویرایش کنید:

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_db_pass');
define('DB_NAME', 'your_db_name');
```

### 3️⃣ نصب دیتابیس

به آدرس زیر بروید:
```
https://esim.matinacard.com/install.php
```

و روی دکمه "شروع نصب" کلیک کنید.

### 4️⃣ حساب مدیر پیش‌فرض

```
موبایل: 09123456789
رمز عبور: admin123
```

⚠️ **مهم:** بعد از نصب، حتماً رمز عبور را تغییر دهید!

---

## ⚙️ تنظیمات

### تنظیم eSIM Access API

فایل `config/config.php` را ویرایش کنید:

```php
define('ESIM_ACCESS_CODE', 'YOUR_ACCESS_CODE');
define('ESIM_SECURITY_KEY', 'YOUR_SECURITY_KEY');
```

### تنظیم ZarinPal

فایل `proxy-handler.php` (روی سرور ایران) را ویرایش کنید:

```php
define('ZARINPAL_MERCHANT_ID', 'YOUR_MERCHANT_ID');
```

### تنظیم نرخ دلار

از پنل مدیریت یا مستقیم در دیتابیس:

```sql
UPDATE settings SET setting_value = '650000' WHERE setting_key = 'usd_to_irr';
```

---

## 🔄 فرآیند پرداخت (Proxy)

```
1. کاربر در سرور آلمان خرید می‌کند
     ↓
2. سرور آلمان درخواست را به سرور ایران ارسال می‌کند
     ↓
3. سرور ایران با ZarinPal تماس می‌گیرد
     ↓
4. ZarinPal لینک پرداخت را برمی‌گرداند
     ↓
5. کاربر پرداخت را انجام می‌دهد
     ↓
6. ZarinPal به سرور آلمان redirect می‌کند
     ↓
7. سرور آلمان تایید را از سرور ایران می‌گیرد
     ↓
8. eSIM از طریق API ساخته و به کاربر داده می‌شود
```

---

## 📊 جداول دیتابیس

### users
- id, mobile, email, password, is_admin, created_at

### orders
- id, user_id, esim_id, country_code, country_name, package_name, package_code
- data_amount, validity_days, price_usd, price_irr
- status, payment_authority, payment_ref_id
- iccid, qr_code, activation_code
- created_at, paid_at

### settings
- id, setting_key, setting_value, updated_at

---

## 🔐 امنیت

- ✅ Session-based authentication
- ✅ Password hashing با bcrypt
- ✅ SQL Injection prevention با prepared statements
- ✅ XSS prevention با htmlspecialchars
- ✅ CSRF protection توصیه می‌شود

---

## 🐛 عیب‌یابی

### خطای "headers already sent"
```php
// اطمینان حاصل کنید که قبل از <?php هیچ فضای خالی یا BOM وجود ندارد
```

### خطای اتصال به دیتابیس
```
- اطلاعات دیتابیس را چک کنید
- مجوزهای کاربر دیتابیس را بررسی کنید
```

### خطای API
```
- Access Code و Security Key را چک کنید
- اتصال اینترنت سرور را بررسی کنید
```

### خطای ZarinPal
```
- Merchant ID را چک کنید
- اطمینان حاصل کنید که سرور ایران به ZarinPal دسترسی دارد
- callback_url را بررسی کنید
```

---

## 📞 پشتیبانی

برای هرگونه سوال یا مشکل:
- 📧 Email: support@matinacard.com
- 🌐 Website: https://esim.matinacard.com

---

## 📝 لایسنس

این پروژه تحت لایسنس MIT است.

---

## 🙏 تشکر

از استفاده از سیستم eSIM متشکریم! 🎉

